  
// CALCOLO CORREZIONE NUTAZIONE E OBLIQUITA' ET
  
function nut_et(JD_ET)
	{  
	 	// Formula del T 
	  	T = (JD_ET - 2415020.0)/36525;
	  
	  	// Formula L 
	  	L = 279.6967+36000.7689*T+0.000303* Math.pow(T,2);
  		/* 
		Ldec = L/360;
	  	Lint = Math.floor(Ldec);
	  	L = (Ldec-Lint)*360; 
  		*/
		L = L*Math.PI/180;
	   
	  	// Formula L1 
	  	L1 = 270.4342+481267.8831*T-0.001133*Math.pow(T,2);
  		/*	
  		L1dec = L1/360;
	  	L1int = Math.floor(L1dec); 
	  	L1 = (L1dec-L1int)*360;
  		*/	
  		L1 = L1*Math.PI/180;
	  
	  	//Formula M 
	  	M = 358.4758+35999.0498*T-0.000150* Math.pow(T,2);
  		/*	
  		Mdec = M/360;
	  	Mint = Math.floor(Mdec); 
	  	M = (Mdec-Mint)*360;
  		*/	
  		M = M*Math.PI/180;
	  
	  	// Formula M1	
	  	M1 = 296.1046+477198.8491*T+0.009192*Math.pow(T,2);
  		/*	
  		M1dec = M1/360;
	  	M1int = Math.floor(M1dec); 
	  	M1 = (M1dec-M1int)*360;
  		*/	
  		M1 = M1*Math.PI/180;
	  
	  	// Formula O 
	  	O = 259.1833-1934.1420*T+0.002078*Math.pow(T,2);
  		/*	
  		Odec = O/360;
	  	Oint = Math.floor(Odec);
	  	O = (Odec-Oint)*360;
  		*/	
  		O = O*Math.PI/180;
	  
	  	DF = 	-(17.2327+0.01737*T)*Math.sin(O)
			  -(1.2729+0.00013*T)*Math.sin(2*L)
			  +0.2088*Math.sin(2*O)
			  -0.2037*Math.sin(2*L1)
			  +(0.1261-0.00031*T)*Math.sin(M)
			  +0.0675*Math.sin(M1)
			  -(0.0497-0.00012*T)*Math.sin(2*L+M)
			  -0.0342*Math.sin(2*L1-O)
			  -0.0261*Math.sin(2*L1+M1)
			  +0.0214*Math.sin(2*L-M)
			  -0.0149*Math.sin(2*L-2*L1+M1)
			  +0.0124*Math.sin(2*L-O)
			  +0.0114*Math.sin(2*L1-M1);
			  	  
	  	DE = 	+(9.2100+0.00091*T)*Math.cos(O)
			  +(0.5522-0.00029*T)*Math.cos(2*L)
			  -0.0904*Math.cos(2*O)
			  +0.0884*Math.cos(2*L1)
			  +0.0216*Math.cos(2*L+M)
			  +0.0183*Math.cos(2*L1-O)
			  +0.0113*Math.cos(2*L1+M1)
			  -0.0093*Math.cos(2*L-M)
			  -0.0066*Math.cos(2*L-O);

		// Obliquità E  
		U = T / 100;
		
		E_g = 23;
		E_p = 26;
		E_ss = 21.448;
		
		E = E_ss / 3600 + E_p / 60 + E_g;
		
		// parametri necessari per la formula seguente 
		a1 = 4680.93 / 3600;
		b1 = 1.55 / 3600;
		c1 = 1999.25 / 3600;
		d1 = 51.38 / 3600;
		e1 = 249.67 / 3600;
		f1 = 39.05 / 3600;
		g1 = 7.12 / 3600 ;
		h1 = 27.87 / 3600;
		i1 = 5.79 / 3600;
		l1 = 2.45 / 3600;
		
		// formula per l'obliquità di laskar 
		E1 = E - a1 * U - b1 * Math.pow(U,2) + c1 * Math.pow(U,3) - d1 * Math.pow(U,4) - e1 * Math.pow(U,5) - f1 * Math.pow(U,6) + g1 * Math.pow(U,7) + h1 * Math.pow(U,8) + i1 * Math.pow(U,9) + l1 * Math.pow(U,10);
	
	 	// formula Jean Meuus 
/*	  	E1 =		23.452294-0.0130125*T
			  -0.00000164*Math.pow(T,2)
			  +0.000000503*Math.pow(T,3);
*/	  
	  
	  	C = 	DF*Math.cos(E1*Math.PI/180)/15;
	  
	  	// Riconversione dei dati L L1 M M1 O in gradi non radianti 
	  	L = L *180/Math.PI;
	  	L1 = L1*180/Math.PI;
	  	M = M*180/Math.PI;
	  	M1 = M1*180/Math.PI;
	  	O = O*180/Math.PI;

	  	return [T,L,L1,M,M1,O,DF,DE,E1,C];
	  	  
}
		  